//---------------------------------------------------------
// Repy1 Modules. Version 1.1                          
// MODULE'S HEAD                                           
//---------------------------------------------------------
//  (c) Juan Gonzalez-Gomez (Obijuan) 2011   
//  GPL license                                                        
//----------------------------------------------------------

//-- The body consist of three parts that are joined by the Union operator
//-- The parts are created by extruding DXF files

use <part-B2.scad>
use <part-E.scad>
use <part-FE.scad>

//----------------------------------------
//-- Repy1 Head
//-- Parameters:
//--    * metric: drills diameter
//--    * thickness: parts thickness
//----------------------------------------
module y1_module_head(thickness=3, metrics=3) 
{
  //-- Get some parameters of the parts
  //-- See the DXF files for the meaning
  xE = B2_get_parameter("xE");
  xFE=B2_get_parameter("xFE");
  yge = E_get_parameter("yg");
  xge = E_get_parameter("xg");
  yg = FE_get_parameter("yg");
  xg = FE_get_parameter("xg");

  //-- Build the module as the union of parts B2, E and FE
  union() {

    //-- Part B2: the base
    part_B2(thickness,metrics);

    //-- Part E: Ear 1
    translate([xE+thickness/2,-xge,yge+thickness/2])
    rotate(a=90, v=[0,1,0]) 
    rotate(a=90, v=[0,0,1])
    part_E(thickness);

    //-- Part FE: Ear 2
    translate([-xFE+thickness/2,-xg,yg+thickness/2])
    rotate([0,90,0])
    rotate([0,0,90])
    part_FE(thickness,metrics);
  };
}

//-- Test example
//-- Build the default Module's head

//-- Set the module's parameters
thickness=3;
metric=3;

//-- Build the module's head and locate it on the z=0 plane
translate([0,0,thickness/2])
  y1_module_head(thickness, metric);



  
 

