//---------------------------------------------------------
// Repy1 Modules. Version 1.1                          
// MODULE'S BODY                                               
//---------------------------------------------------------
//  (c) Juan Gonzalez-Gomez (Obijuan) 2011   
//  GPL license                                                        
//----------------------------------------------------------

//-- The body consist of three parts that are joined by the Union operator
//-- The parts are created by extruding DXF files

use <part-B1.scad>
use <part-F.scad>
use <part-FE.scad>

//----------------------------------------
//-- Repy1 Body
//-- Parameters:
//--    * metric: drills diameter
//--    * thickness: parts thickness
//----------------------------------------
module repy1_body(thickness=3, metrics=3)
{

  //-- Get some parameters of the parts
  //-- See the DXF files for the meaning
  xF = B1_get_parameter("xF");
  xFE=B1_get_parameter("xFE");
  yg = FE_get_parameter("yg");
  xg = FE_get_parameter("xg");
  W=thickness;


  //-- Build the module as the union of parts B1, F and FE
  union() {

    //-- Part B1: the base
    part_B1(thickness, metrics);

    //-- Part F: Where the Futaba 3003 is attached
    translate([xF+thickness/2,0,26+thickness/2])
    rotate(a=-90, v=[0,0,1]) 
    rotate(a=90, v=[1,0,0]) part_F(thickness,metrics);

    //-- Part FE: The 'ear'
    translate ([-xFE-thickness/2,xg,yg+thickness/2])
    rotate([0,-90,0])
    rotate([0,0,-90])
    part_FE(thickness, metrics, countersink=6);
  };
}


//-- Test example
//-- Build the default Module's body

//-- Set the module's parameters
thickness=3;
metric=3;

//-- Build the module's body and locate it on the z=0 plane
translate([0,0,thickness/2])
  repy1_body(thickness, metric);


  
 

